using System;
using System.Collections.Generic;
using System.Text;

namespace CannibalProblem
{
    public class CannibalState
    {
        private List<string> histroy;
        public enum Position { Left, Right };
        private Position boatPosition;
        private int lCannibals;
        private int rCannibals;
        private int lMissionaries;
        private int rMissionaries;

        public Position BoatPosition
        {
            get
            {
                return boatPosition;
            }
        }

        public int LCannibals
        {
            get
            {
                return lCannibals;
            }
        }

        public int RCannibals
        {
            get
            {
                return rCannibals;
            }
        }

        public int LMissionaries
        {
            get
            {
                return lMissionaries;
            }
        }

        public int RMissionaries
        {
            get
            {
                return rMissionaries;
            }
        }

        public List<string> History
        {
            get
            {
                return histroy;
            }
        }

        public CannibalState(Position pos, int lcannibals, int lmissionaries, int rcannibals, int rmissionaries)
        {
            histroy = new List<string>();
            boatPosition = pos;
            this.lMissionaries = lmissionaries;
            this.rMissionaries = rmissionaries;
            this.lCannibals = lcannibals;
            this.rCannibals = rcannibals;
        }

        public CannibalState Left2Right(int cannibalNum, int missionaryNum)
        {
            CannibalState temp = null;
            if (!(cannibalNum == 0 && missionaryNum == 0))
            {
                if (lMissionaries >= missionaryNum && lCannibals >= cannibalNum && boatPosition == Position.Left)
                {
                    temp = this.Clone();
                    temp.histroy.Add(string.Format("Go Right\t\t(C={0}, M={1})", cannibalNum, missionaryNum));
                    temp.lMissionaries -= missionaryNum;
                    temp.rMissionaries += missionaryNum;
                    temp.lCannibals -= cannibalNum;
                    temp.rCannibals += cannibalNum;
                    temp.boatPosition = Position.Right;
                }
            }
            return temp;
        }

        public CannibalState Right2Left(int cannibalNum, int missionaryNum)
        {
            CannibalState temp = null;
            if (!(cannibalNum == 0 && missionaryNum == 0))
            {
                if (RCannibals >= cannibalNum && RMissionaries >= missionaryNum && boatPosition == Position.Right)
                {
                    temp = this.Clone();
                    temp.histroy.Add(string.Format("Go Left\t\t(C={0}, M={1})", cannibalNum, missionaryNum));
                    temp.rMissionaries -= missionaryNum;
                    temp.lMissionaries += missionaryNum;
                    temp.rCannibals -= cannibalNum;
                    temp.lCannibals += cannibalNum;
                    temp.boatPosition = Position.Left;
                }
            }
            return temp;
        }

        public CannibalState Clone()
        {
            CannibalState temp = new CannibalState(boatPosition, lCannibals, lMissionaries, rCannibals, rMissionaries);
            temp.histroy = new List<string>();
            foreach (string str in histroy)
                temp.histroy.Add(str);
            return temp;
        }

        public bool IsValid()
        {
            if ((lMissionaries != 0 && lMissionaries < lCannibals) || (rMissionaries != 0 && rMissionaries < rCannibals))
                return false;
            return true;
        }


        public override bool Equals(object obj)
        {
            if (boatPosition == ((CannibalState)obj).boatPosition &&
                lCannibals == ((CannibalState)obj).lCannibals &&
                rCannibals == ((CannibalState)obj).rCannibals &&
                lMissionaries == ((CannibalState)obj).lMissionaries &&
                rMissionaries == ((CannibalState)obj).rMissionaries)
                return true;
            return false;
        }
    }
}
